/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.settings.loot;

import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.roguelike.settings.loot.ArmourLootItemParser;
import com.github.fnar.roguelike.settings.loot.EnchantedBookLootItemParser;
import com.github.fnar.roguelike.settings.loot.MinecraftItemLootItemParser;
import com.github.fnar.roguelike.settings.loot.MixtureParser;
import com.github.fnar.roguelike.settings.loot.NoveltyLootItemParser;
import com.github.fnar.roguelike.settings.loot.PotionLootItemParser;
import com.github.fnar.roguelike.settings.loot.SpecialtyLootItemParser;
import com.github.fnar.roguelike.settings.loot.ToolLootItemParser;
import com.github.fnar.roguelike.settings.loot.WeaponLootItemParser;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.settings.DungeonSettingParseException;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.WeightedChoice;

public class LootItemParser {
    public static IWeighted<RldItemStack> parseLootItem(JsonObject data, int weight) {
        return data.has("type") ? LootItemParser.parseGreymerkLootItemThing(data, weight) : MinecraftItemLootItemParser.parse(data, weight);
    }

    private static IWeighted<RldItemStack> parseGreymerkLootItemThing(JsonObject data, int weight) {
        String type = data.get("type").getAsString().toUpperCase();
        switch (LootType.valueOf(type)) {
            case POTION: {
                return new WeightedChoice<RldItemStack>(new PotionLootItemParser().parsePotion(data).asStack(), weight);
            }
            case MIXTURE: {
                return MixtureParser.parse(data, weight);
            }
            case WEAPON: {
                return WeaponLootItemParser.parse(data, weight);
            }
            case SPECIALTY: {
                return SpecialtyLootItemParser.parse(data, weight);
            }
            case NOVELTY: {
                return NoveltyLootItemParser.parse(data, weight);
            }
            case TOOL: {
                return ToolLootItemParser.parse(data, weight);
            }
            case ARMOUR: {
                return ArmourLootItemParser.parse(data, weight);
            }
            case ENCHANTED_BOOK: {
                return EnchantedBookLootItemParser.parse(data, weight);
            }
        }
        throw new DungeonSettingParseException("No such loot type as: " + type);
    }

    private static enum LootType {
        POTION,
        MIXTURE,
        WEAPON,
        SPECIALTY,
        NOVELTY,
        TOOL,
        ARMOUR,
        ENCHANTED_BOOK;

    }
}

